<?php
// Conecta ao banco de dados SQLite
$db = new SQLite3(__DIR__ . '/api/.dbmaxrebrands.db');

// Consulta o banco de dados para obter a URL do vídeo da tabela 'intro' e coluna 'url'
$query = "SELECT url FROM intro LIMIT 1"; // Garantir que seja retornada apenas uma URL
$result = $db->query($query);
$row = $result->fetchArray(SQLITE3_ASSOC);

// Verifica se a URL foi encontrada
if ($row) {
    $url = trim($row['url']);
    $url = str_replace(" ", "%20", $url);
} else {
    // Caso não encontre a URL no banco de dados, loga o erro e termina a execução
    logDebug("Erro: URL não encontrada no banco de dados.");
    exit("Erro: URL não encontrada.");
}

// Função para escrever os logs no arquivo debug.txt
function logDebug($message) {
    $logFile = './splashscreen/debug.txt';
    $timestamp = date("Y-m-d H:i:s");
    $logMessage = "[$timestamp] $message\n";
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

// Adiciona o debug da URL
logDebug("URL requisitada: $url");

// Verifica se o método GET 'info' foi passado com o valor 'head'
if (isset($_GET['info']) && $_GET['info'] === 'head') {
    // Inicializa o cURL
    $ch = curl_init();

    // Configurações do cURL para obter apenas os cabeçalhos
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true); // Incluir os cabeçalhos na resposta
    curl_setopt($ch, CURLOPT_NOBODY, false); // Não baixar o corpo do conteúdo

    // Executa a requisição
    $response = curl_exec($ch);

    // Verifica se houve erro no cURL
    if (curl_errno($ch)) {
        $error = 'Erro: ' . curl_error($ch);
        logDebug($error); // Adiciona erro ao log
        header("Content-Type: text/plain");
        echo $error;
        curl_close($ch);
        exit;
    }

    // Obtém o tamanho do vídeo a partir do cabeçalho Content-Length
    $contentLength = curl_getinfo($ch, CURLINFO_CONTENT_LENGTH_DOWNLOAD);

    // Adiciona o tamanho ao log
    logDebug("Tamanho do vídeo: $contentLength");

    // Verifica se o tamanho foi obtido
    if ($contentLength != -1) {
        // Retorna o tamanho do vídeo
        header("Content-Type: text/plain");
        echo $contentLength;
    } else {
        echo "Não foi possível determinar o tamanho do vídeo.";
    }

    // Fecha a sessão do cURL
    curl_close($ch);
} else {
    // Inicializa o cURL para obter o conteúdo do vídeo
    $ch = curl_init();

    // Configurações do cURL
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    // Obtém o conteúdo do vídeo
    $videoContent = curl_exec($ch);

    // Verifica se houve erro no cURL
    if (curl_errno($ch)) {
        $error = 'Erro: ' . curl_error($ch);
        logDebug($error); // Adiciona erro ao log
        header("Content-Type: text/plain");
        echo $error;
        curl_close($ch);
        exit;
    }

    // Obtém informações sobre o tipo MIME usando fileinfo
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $tempFile = tempnam(sys_get_temp_dir(), 'video_');
    file_put_contents($tempFile, $videoContent);
    $mimeType = finfo_file($finfo, $tempFile);
    finfo_close($finfo);
    unlink($tempFile);

    // Adiciona o tipo MIME ao log
    logDebug("Tipo MIME: $mimeType");

    // Define os headers HTTP apropriados
    header("Content-Type: $mimeType");
    header("Content-Length: " . strlen($videoContent));
    header("Accept-Ranges: bytes");
    header("Content-Disposition: inline");

    // Exibe o conteúdo do vídeo
    echo $videoContent;

    // Fecha a sessão do cURL
    curl_close($ch);
}
?>
